local c;
local player = Var "Player";

local JudgeCmds = {
	TapNoteScore_W1 = THEME:GetMetric( "Judgment", "JudgmentW1Command" );
	TapNoteScore_W2 = THEME:GetMetric( "Judgment", "JudgmentW2Command" );
	TapNoteScore_W3 = THEME:GetMetric( "Judgment", "JudgmentW3Command" );
	TapNoteScore_W4 = THEME:GetMetric( "Judgment", "JudgmentW4Command" );
	TapNoteScore_W5 = THEME:GetMetric( "Judgment", "JudgmentW5Command" );
	TapNoteScore_Miss = THEME:GetMetric( "Judgment", "JudgmentMissCommand" );
};

local TNSFrames = {
	TapNoteScore_W1 = 0;
	TapNoteScore_W2 = 1;
	TapNoteScore_W3 = 2;
	TapNoteScore_W4 = 3;
	TapNoteScore_W5 = 4;
	TapNoteScore_Miss = 5;
};

local t = Def.ActorFrame {
	InitCommand=cmd(fov,90);
	
	LoadActor("_judgments") .. {
		Name="Judgment";
		InitCommand=cmd(pause;visible,false);
		ResetCommand=cmd(finishtweening;x,0;y,0;stopeffect;visible,false;glow,1,1,1,0;);
	};
	InitCommand = function(self)
		c = self:GetChildren();
	end;

	JudgmentMessageCommand=function(self, param)
		if param.Player ~= player then return end;
		if not param.TapNoteScore then return end;

		local iNumStates = c.Judgment:GetNumStates();
		local iFrame = TNSFrames[param.TapNoteScore];
		if not iFrame then return end
		if iNumStates == 12 then
			iFrame = iFrame * 2;
			if not param.Early then
				iFrame = iFrame + 1;
			end
		end
		self:playcommand("Reset");

		c.Judgment:visible( true );
		c.Judgment:setstate( iFrame );
		
		c.Judgment:diffusealpha(1);
		c.Judgment:rotationx(-45);
		c.Judgment:rotationy(player == PLAYER_1 and -10 or 10)
		c.Judgment:rotationz(player == PLAYER_1 and -3 or 3);
		
		c.Judgment:linear(0.1);
		
		c.Judgment:rotationx(player == PLAYER_1 and -4.5 or 4.5);
		c.Judgment:rotationy(0);
		(cmd(sleep,0.8;linear,0.1;rotationx,0;rotationz,0;diffusealpha,0))(c.Judgment);
		--JudgeCmds[param.TapNoteScore](c.Judgment);
	end;
};

return t;
